!	This file should be filed in with SystemUser privileges, since it consists of extentions to core classes.
!
category: 'SmallInterfaces'
method: Behavior
>> selector
	"Answer the receiver's method named selector.
	 Error if the receiver does not define a method named selector."

	^self compiledMethodAt: selector
%
category: 'SmallInterfaces'
method: Behavior
categoryOfElement: selector 
	"Answer a category associated with the argument, selector."
	
	^self categoryOfSelector: selector

%
category: 'SmallInterfaces'
method: Behavior
commentFor: selector

	| source start stop |
	self needsFurtherWork.	"this is a very crude approach which can fail for many reasons..."
	source := (self >> selector) sourceString.
	(source occurrencesOf: $") < 2 ifTrue: [^''].
	start := source indexOf: $" startingAt: 1. 
	stop := source indexOf: $" startingAt: (start + 1).
	^stop > (start + 1)
		ifTrue: [source copyFrom: (start + 1) to: (stop - 1)]
		ifFalse: ['']
%
category: 'SmallInterfaces'
method: Behavior
compile: code
	"Compile the argument, code, as source code in the context of the receiver and
	install the result in the receiver's method dictionary under its existing protocol 
	if it has one, otherwise a default protocol. nil is to be notified if an error occurs.
	The argument code is either a string or an object that converts to a string or a
	PositionableStream on an object that converts to a string."

	^self
		compile: code
		classified: ClassOrganizer defaultProtocol
%
category: 'SmallInterfaces'
method: Behavior
compile: code classified: heading 

	^self
		compile: code
		classified: heading
		notifying: nil
%
category: 'SmallInterfaces'
method: Behavior
compile: code classified: heading notifying: requestor 

	^self
		compileMethod: code
		dictionaries: self environment
		category: heading
%
category: 'SmallInterfaces'
method: Behavior
emptyCategories

	^self categoryNames select: [:each | (self selectorsIn: each) isEmpty]
%
category: 'SmallInterfaces'
method: Behavior
environment
	"Answer the class's compilation scope."

	^System myUserProfile symbolList
%
category: 'SmallInterfaces'
method: Behavior
listAtCategoryNamed: categoryName
	"Answer the array of elements associated with the name, categoryName."

	^self selectorsInCategory: categoryName
%
category: 'SmallInterfaces'
method: Behavior
methodDictionary

	^self _methodDict
%
category: 'SmallInterfaces'
method: Behavior
organization

	^self
%
category: 'SmallInterfaces'
method: Behavior
removeAllEmptyCategories

	self emptyCategories do: [:each | self removeCategory: each]
%
category: 'SmallInterfaces'
method: Behavior
selectorsInCategory: categoryName 

	^(self categoryNames includes: categoryName)
		ifTrue: [self selectorsIn: categoryName]
		ifFalse: [#()]
%
category: 'SmallInterfaces'
method: Behavior
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Block
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Block
whileTrue
	"Evaluate the receiver once and then repeatedly as long as the value
	returned by the evaluation is true."

	^[self value] whileTrue: []
%
category: 'SmallInterfaces'
method: Class
allSubclasses

	^ClassOrganizer new allSubclassesOf: self
%
category: 'SmallInterfaces'
method: Class
asInterface

	^self asInterfaceNamed: self defaultInterfaceName
%
category: 'SmallInterfaces'
method: Class
asInterfaceNamed: aString

	(self interfaceClass home includesInterfaceNamed: aString) 
		ifTrue: [^self error: aString asString, ' interface already exists!'].

	^self interfaceClass newNamed: aString from: self
%
category: 'SmallInterfaces'
method: Class
byteSubclass: aString
	classVars: anArrayOfClassVars
	classInstVars: anArrayOfClassInstVars
	poolDictionaries: anArrayOfPoolDicts
	inDictionary: aDictionary
	instancesInvariant: invarBoolean
 	interfaces: stringOfInterfaces

	| class |
	class := self
		byteSubclass: aString
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		instancesInvariant: invarBoolean.
	class implementInterfacesNamed: stringOfInterfaces.		
	^class
%
category: 'SmallInterfaces'
method: Class
defaultInterfaceName

	^self name, 'Interface'
%
category: 'SmallInterfaces'
method: Class
definitionWithInterfaces 

	| writer classInterfacesSelector classInterfaces |
	writer := String newLarge writeStream.
	writer
		nextPutAll: self definition;
		crtab;
		nextPutAll: 'interfaces: ';
		nextPut: $'.
	classInterfacesSelector := self interfaceClass configuration selectorForClassInterfaces.
	classInterfaces := (self perform: classInterfacesSelector) asSortedCollection: Class sortBlock.
	classInterfaces do: [:each | writer nextPutAll: each name asString; space].
	writer nextPut: $'.
	^writer contents
%
category: 'SmallInterfaces'
method: Class
discardExistingInterfacesNottIn: interfaces

self needsFurtherWork.	
"Since interfaces can overlap, we need to remove only the portion not overlapping.
for now, the following will do."

	self unimplementInterfaces: (self implementedInterfaces - interfaces)
%
category: 'SmallInterfaces'
method: Class
implementationStringForInterface

	^String newLarge writeStream
		nextPutAll: '^self';
		space;
		nextPutAll: self interfaceClass selectorForImplementation asString;
		contents
%
category: 'SmallInterfaces'
method: Class
implementedInterfaces

	^self interfaceClass home allInterfaces select: [:each | self implements: each]
%
category: 'SmallInterfaces'
method: Class
implementedInterfacesMinimalSet
	"What is the minimal set of interfaces which fully 
	describe the repertoire of all interfaces I implement?"
	
	^self interfaceClass consolidate: self implementedInterfaces
%
category: 'SmallInterfaces'
method: Class
implementInterface: anInterface
	"Create implementations for all of <anInterface> methods which I do not understand yet."

	self implementInterface: anInterface enforce: false
%
category: 'SmallInterfaces'
method: Class
implementInterface: anInterface enforce: enforcing
	"Create methods implementations on behalf of <anInterface>.
	If <enforcing>, create implementations for all of <anInterface>'s repetoire (rather then merely 
	understand it). If not, create implementations only for the part I do not understand yet."

	| selectorsToBeImplemented |
	selectorsToBeImplemented := (enforcing or: [anInterface mustBeImplemented])
		ifTrue: [anInterface methodsNotImplementedBy: self]
		ifFalse: [anInterface methodsNotUnderstoodBy: self].
	selectorsToBeImplemented do: [:each | anInterface createStubbedMethodFor: each from: self]
%
category: 'SmallInterfaces'
method: Class
implementInterfaces: interfaces 

	interfaces do: [:each | self implementInterface: each]
%
category: 'SmallInterfaces'
method: Class
implementInterfaces: interfaces discardExisting: discarding
	"Create implementations for <interfaces>.
	If <discarding>, discard existing implementations of interfaces not in <interfaces>."

	discarding ifTrue: [self discardExistingInterfacesNottIn: interfaces].
	self implementInterfaces: interfaces.
%
category: 'SmallInterfaces'
method: Class
implementInterfacesNamed: stringOfInterfaces 

	self 
		implementInterfaces: (self interfaceClass interfacesFromString: stringOfInterfaces)
		discardExisting: true.
%
category: 'SmallInterfaces'
method: Class
implements: anInterface
	"Do I directly implement all of <anInterface> repertoire?
	Note the difference between implementing and understanding."

	^anInterface isImplementedBy: self
%
category: 'SmallInterfaces'
method: Class
indexableSubclass: aString
	instVarNames: anArrayOfStrings
	classVars: anArrayOfClassVars
	classInstVars: anArrayOfClassInstVars
	poolDictionaries: anArrayOfPoolDicts
	inDictionary: aDictionary
	constraints: aConstraint
	instancesInvariant: invarBoolean
	isModifiable: modifyBoolean
 	interfaces: stringOfInterfaces

	| class |
	class := self
		indexableSubclass: aString
		instVarNames: anArrayOfStrings
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		constraints: aConstraint
		instancesInvariant: invarBoolean
		isModifiable: modifyBoolean.
	class implementInterfacesNamed: stringOfInterfaces.		
	^class
%
category: 'SmallInterfaces'
method: Class
interfaceClass
	
	^(GsSession currentSession resolveSymbol: #Interface) value
%
category: 'SmallInterfaces'
method: Class
isEmbodiedIn: anObject

	^anObject isKindOf: self
%
category: 'SmallInterfaces'
method: Class
repertoire
	"Note: the original implementation was - ^self allSelectors.
	However, since this was very slow, a new caching scheme can be used instead."
	
	^self repertoireHomeClass current repertoireFor: self
%
category: 'SmallInterfaces'
method: Class
repertoireHomeClass
	
	^(GsSession currentSession resolveSymbol: #RepertoireHome) value
%
category: 'SmallInterfaces'
method: Class
repertoireImplemented

	^self selectors
%
category: 'SmallInterfaces'
method: Class
requiredInterfaces
	"This method is a template which aims to facilitate documenting the interfaces a class should be able to understand.
	At that point the question <aBehavior understandsRequiredInterfaces> becomes meaningful."
	
	self subclassesShouldOverride.
	^#()
%
category: 'SmallInterfaces'
method: Class
subclass: aString
	instVarNames: anArrayOfStrings
	classVars: anArrayOfClassVars
	classInstVars: anArrayOfClassInstVars
	poolDictionaries: anArrayOfPoolDicts
	inDictionary: aDictionary
	constraints: aConstraint
	instancesInvariant: invarBoolean
	isModifiable: modifyBoolean
 	interfaces: stringOfInterfaces

	| class |
	class := self
		subclass: aString
		instVarNames: anArrayOfStrings
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		constraints: aConstraint
		instancesInvariant: invarBoolean
		isModifiable: modifyBoolean.
	class implementInterfacesNamed: stringOfInterfaces.		
	^class
%
category: 'SmallInterfaces'
method: Class
subclass: aString
	instVarNames: anArrayOfStrings
	inDictionary: aDictionary
	constraints: constraintSpec
 	interfaces: stringOfInterfaces

	^self
		subclass: aString
		instVarNames: anArrayOfStrings
		classVars: #() 
		classInstVars: #()
		poolDictionaries: #()
		inDictionary: aDictionary
		constraints: constraintSpec
		instancesInvariant: false
		isModifiable: false
 		interfaces: stringOfInterfaces

%
category: 'SmallInterfaces'
method: Class
subclass: aString
	instVarNames: anArrayOfStrings
	inDictionary: aDictionary
 	interfaces: stringOfInterfaces

	^self
		subclass: aString
		instVarNames: anArrayOfStrings
		classVars: #() 
		classInstVars: #()
		poolDictionaries: #()
		inDictionary: aDictionary
 		constraints: #[]
		instancesInvariant: false
		isModifiable: false
		interfaces: stringOfInterfaces

%
category: 'SmallInterfaces'
method: Class
subclasses

	^(ClassOrganizer new subclassesOf: self) asOrderedCollection
%
category: 'SmallInterfaces'
method: Class
understands: anInterface
	"Can my instances respond to all of <anInterface> repertoire?
	Note the difference between implementing and understanding."

	^anInterface isUnderstoodBy: self
%
category: 'SmallInterfaces'
method: Class
understandsAll: collectionOfInterfaces
	"This method aims to help with design validation"
	
	^collectionOfInterfaces
		inject: true
		into: 
			[:truth :interface |
			truth and: [self understands: interface]]
%
category: 'SmallInterfaces'
method: Class
understandsRequiredInterfaces
	"This method aims to help with design validation"
	
	^self requiredInterfaces
		inject: true
		into: 
			[:truth :interface |
			truth and: [self understands: interface]]
%
category: 'SmallInterfaces'
method: Class
understoodInterfaces

	^self interfaceClass home allInterfaces select: [:each | self understands: each]
%
category: 'SmallInterfaces'
method: Class
understoodInterfacesMinimalSet
	"What is the minimal set of interfaces which fully 
	describe the repertoire of all interfaces I understand?"

	^self interfaceClass consolidate: self understoodInterfaces
%
category: 'SmallInterfaces'
method: Class
unimplementInterface: anInterface
	"Remove implementations for all of <anInterface> repertoire I already implement."

	self unimplementInterface: anInterface enforce: true
%
category: 'SmallInterfaces'
method: Class
unimplementInterface: anInterface enforce: enforcing
	"Remove all methods implemented on behalf of <anInterface>.
	If <enforcing>, remove my implementions of <anInterface>'s repetoire.
	If not, remove only the the stubbed implementations."

	| selectorsToBeRemoved |
	selectorsToBeRemoved := enforcing
		ifTrue: [anInterface methodsImplementedBy: self]
		ifFalse: [anInterface methodsStubbedIn: self].
	selectorsToBeRemoved do: [:each | self removeSelector: each ifAbsent: []].
	self removeAllEmptyCategories.
%
category: 'SmallInterfaces'
method: Class
unimplementInterfaces: interfaces

	interfaces do: 
		[:each | 
		self 
			unimplementInterface: each 
			enforce: (self interfaceClass configuration removeOnlyStubbedImplementations not)]
%
category: 'SmallInterfaces'
method: Class
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Collection
, aCollection 
	"Answer a copy of the receiver agregated with the argument, aCollection."

	^self copy 
		addAll: aCollection;
		yourself
%
category: 'SmallInterfaces'
method: Collection
allSatisfy: aBlock 
	"Note that an empty collection will return true!
	<'some' allSatisfy: [:each | each isCharacter]>
	<#() allSatisfy: [:each | each isNumber]>
	<'some' allSatisfy: [:each | each == true]>"
	
	^(self select: aBlock) includesAll: self
%
category: 'SmallInterfaces'
method: Collection
consistsOf: aCollection 
	"Returns true if the contents of the receiver and <aCollection> 
	are exactly the same - order doesn't matter."

	^self size = aCollection size and: [self includesAllOccurrences: aCollection]
%
category: 'SmallInterfaces'
method: Collection
contains: aBlock 
	"Evaluate aBlock with each of the receiver's elements as the argument. 
	Answer true if aBlock ever evaluates to true, otherwise answer false."

	self detect: aBlock ifNone: [^false].
	^true
%
category: 'SmallInterfaces'
method: Collection
flattened
	"Answer a new collection containing all my elements, flattened,
	which means: if an element is a collection, then flatten it as well (recursively).
	<#(1 #(2 3 4) #(10 #(12 13 14 #(#(100) 200 #(251 252) 300 400)))) flattened>"

	| newCollection |
	newCollection := self species new: self size.
	self do: 
		[:each | 
		each isCollection
			ifTrue: [newCollection addAll: each flattened]
			ifFalse: [newCollection add: each]].
	^newCollection
%
category: 'SmallInterfaces'
method: Collection
includesAll: aCollection
	"Answer whether the receiver includes each element of aCollection."

	aCollection do: [:each | (self includes: each) ifFalse: [^false]].
	^true
%
category: 'SmallInterfaces'
method: Collection
includesAllOccurrences: aCollection 
	"Return true if the receiver includes all elements in aCollection. 
	If aCollection contains duplicate elements, the receiver must have one for each of them."

	| meAsBag otherBag |
	aCollection size > self size ifTrue: [^false].
	otherBag := aCollection asBag.
	meAsBag := self asBag.
	otherBag do: [:each | (meAsBag occurrencesOf: each) < (otherBag occurrencesOf: each) ifTrue: [^false]].
	^true
%
category: 'SmallInterfaces'
method: Collection
includesAny: aCollection
	"Return true if the receiver includes any of the elements in aCollection."

	aCollection do: [:each | (self includes: each) ifTrue: [^true]].
	^false
%
category: 'SmallInterfaces'
method: Collection
intersectionWith: anotherCollection
	"Return the elements in common with receiver and anotherCollection 
	as an appropriate collection with one instance of each element."

	^anotherCollection intersectionWithSet: self asSet
%
category: 'SmallInterfaces'
method: Collection
intersectionWithSet: aSet
	"Return the elements in common with receiver and anotherCollection 
	as an appropriate collection with one instance of each element."

	^self asSet intersectionWithSet: aSet
%
category: 'SmallInterfaces'
method: Collection
isCollection
	"Answer whether the receiver is a <Collection>."

	^true
%
category: 'SmallInterfaces'
method: Collection
keysAndValuesDo: a2ArgBlock 
	"Evaluate <a2ArgBlock> with each of the receiver's key/value pairs as the arguments,
	where an arbitrary index is the key, and element is the value.
	<'ABC' asSet keysAndValuesDo: [:index :each | Transcript show: index printString; tab; show: each; cr]>"

	| index |
	index := 0.
	self do: [:each | a2ArgBlock value: (index := index + 1) value: each]
%
category: 'SmallInterfaces'
method: Collection
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Object
conformsTo: anInterface
	"Can I respond to any message in <anInterface> repertoire?"

	^self class understands: anInterface
%
category: 'SmallInterfaces'
method: Object
ends: aSequenceableCollection
	"Answer whether the last element of aSequenceableCollection is equal to the receiver."

	^aSequenceableCollection last = self
%
category: 'SmallInterfaces'
method: Object
environment

	^self class environment
%
category: 'SmallInterfaces'
method: Object
ifNil: ignored 
	"since I am not nil, return myself.
	NOTE: this message should be inlined by compiler."

	^self
%
category: 'SmallInterfaces'
method: Object
isCollection
	"Answer whether the receiver is an instance of a kind of Collection."

	^false
%
category: 'SmallInterfaces'
method: Object
isInterface

	^false
%
category: 'SmallInterfaces'
method: Object
isTypeOf: aClassOrInterface

	^aClassOrInterface isEmbodiedIn: self
%
category: 'SmallInterfaces'
method: Object
needsFurtherWork
	"Marks code that needs further work.
	It is assumed to be left 'in the middle' of developement."
%
category: 'SmallInterfaces'
method: Object
shouldImplementFor: anInterface 
	"This method is used to mark a method as one generated (and stubbed) for an interface."

	^anInterface implementorsResponsibility
%
category: 'SmallInterfaces'
method: Object
starts: aSequenceableCollection
	"Answer whether the first element of aSequenceableCollection is equal to the receiver."

	^aSequenceableCollection first = self
%
category: 'SmallInterfaces'
method: Object
subclassesShouldOverride
	"Unlike #subclassResponsibility, this is a recommendation only."
%
category: 'SmallInterfaces'
method: Object
types
	"Which are all the types which I embody?
	Definition: Type = (Class | Interface)"

	^self class allSuperclasses 
		addAll: self class understoodInterfaces;
		yourself
%
category: 'SmallInterfaces'
method: Object
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: SequenceableCollection
ends: aSequenceableCollection 
	"Answer whether the last elements of aSequenceableCollection are equal to the elements of the reciever."

	^self reverse starts: aSequenceableCollection reverse
%
category: 'SmallInterfaces'
method: SequenceableCollection
endsWith: aSequenceableCollectionOrObject  
	"if aSequenceableCollectionOrObject is a <SequenceableCollection>, answer whether the 
	last elements of the receiver, respectively, are equal to the elements of the <SequenceableCollection>.
	if aSequenceableCollectionOrObject is any other kind of object, answer whether the 
	last element of the receiver equals to that <Object>."

	^aSequenceableCollectionOrObject ends: self
%
category: 'SmallInterfaces'
method: SequenceableCollection
keysAndValuesDo: aBlock  
	"Evaluate aBlock with each of the receiver's key/value pairs
	(e.g. indexes and elements) as the arguments."

	1 to: self size do: [:i | aBlock value: i value: (self at: i)]
%
category: 'SmallInterfaces'
method: SequenceableCollection
nextIndexOf: anElement from: startIndex to: stopIndex
	"Answer the next index of anElement within the receiver between startIndex and stopIndex.
	 If the receiver does not contain anElement, answer nil"

	startIndex to: stopIndex do: [:i | (self at: i) = anElement ifTrue: [^i]].
	^nil
%
category: 'SmallInterfaces'
method: SequenceableCollection
reversed

	^self reverse
%
category: 'SmallInterfaces'
method: SequenceableCollection
starts: aSequenceableCollection 
	"Answer whether the first elements of aSequenceableCollection are equal to the elements of the reciever.
	<'in' starts: 'in the beginning...' >"

	(self isEmpty or:
	[aSequenceableCollection size < self size]) ifTrue: [^false].
		
	1 to: self size do: [:each | (aSequenceableCollection at: each) = (self at: each) ifFalse: [^false]].
	^true
%
category: 'SmallInterfaces'
method: SequenceableCollection
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: SequenceableCollection
withIndexDo: a2ArgBlock 
	"Evaluate <a2ArgBlock> with each of the receiver's key/value pairs as the arguments,
	where index is the key, and element is the value.
	<'ABC' withIndexDo: [:index :each | Transcript show: index printString; tab; show: each; cr]>"
	
	^self keysAndValuesDo: a2ArgBlock
%
category: 'SmallInterfaces'
method: SequenceableCollection
writeStream
	"Answer a writeStream on the receiver.  Subclasses can provide their own kinds of Stream here."

	^WriteStream on: self
%
category: 'SmallInterfaces'
method: Stream
crtab
	"Append a return character, followed by a single tab character, to the receiver."

	self cr; tab
%
category: 'SmallInterfaces'
method: Stream
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: String
asClass
	"Answer the class I designate."

	^self asSymbol asClass
%
category: 'SmallInterfaces'
method: String
asText

	^self
%
category: 'SmallInterfaces'
method: String
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: UndefinedObject
ifNil: aBlock 
	"since I am nil, return the evaluation of aBlock.
	NOTE: this message should be inlined by compiler."

	^aBlock value
%
category: 'SmallInterfaces'
method: UndefinedObject
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: SymbolList
allClasses
	"<self environment allClasses>"

	^self 
		inject: ClassSet new
		into: [:set :each | set addAll: each classes. set]
		
"???	^ClassOrganizer new classes"
%
category: 'SmallInterfaces'
method: SymbolList
allNonInterfaceClasses
	"<self environment allNonInterfaceClasses>"

	^self allClasses reject: [:each | each isInterface]
%
category: 'SmallInterfaces'
method: SymbolList
at: aSymbol ifAbsent: absentBlock

	| object |
	^(object := self objectNamed: aSymbol) notNil
		ifTrue: [object]
		ifFalse: [absentBlock value]
%
category: 'SmallInterfaces'
method: SymbolList
defaultDictionaryForNewClasses

	^(GsSession currentSession resolveSymbol: #UserClasses) value
%
category: 'SmallInterfaces'
method: SymbolList
hasClassNamed: aClassName
	"Answer if the receiver contains a behavior with name aClassName."

	^(self at: aClassName ifAbsent: [nil]) isBehavior
%
category: 'SmallInterfaces'
method: SymbolList
includesKey: aSymbol

	^(self objectNamed: aSymbol) notNil

%
category: 'SmallInterfaces'
method: SymbolList
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: CharacterCollection
asClass
	"Answer the class I designate."

	^self asSymbol asClass
%
category: 'SmallInterfaces'
method: CharacterCollection
asSequenceableCollection: aChar 
	"Answer a Collection of lines in me. 
	The end-of-line character is aChar."

	| lines lastEOL |
	lines := OrderedCollection new.
	lastEOL := 0.
	1 to: self size do: 
		[:i | 
		(self at: i) = aChar
			ifTrue: 
				[| start stop |
				start := lastEOL + 1.
				stop := i - 1.
				lines addLast: (start > stop
					ifTrue: [String new]
					ifFalse: [self copyFrom: start to: stop]).
				lastEOL := i]].
		"deal with last line if not terminated"
	lastEOL = self size ifFalse: [lines addLast: (self copyFrom: lastEOL + 1 to: self size)].
	^lines
%
category: 'SmallInterfaces'
method: CharacterCollection
asWords
	"Return a copy of receiver with a space inserted between 
	a lower case letter and a following upper case letter. 
	<'aVISACard' asWords>"

	| workStream lastWasLowerCase |
	workStream := (String new: self size * 2) writeStream.
	lastWasLowerCase := false.
	1 to: self size do: 
		[:each | 
		(self at: each) isUppercase	"bootstrap condition"	
			ifTrue: 
				[lastWasLowerCase
					ifTrue: [workStream space]
					ifFalse: [(each > 1 and: [(self at: each + 1) isLowercase]) ifTrue: [workStream space]].
				lastWasLowerCase := false]
			ifFalse: [lastWasLowerCase := true].
		workStream nextPut: (self at: each)].
	^workStream contents
%
category: 'SmallInterfaces'
method: CharacterCollection
capitalized
	"Answer a copy whose first character is capitalized.
	<#who capitalized>"

	| copy |
	copy := self species withAll: self.
	copy notEmpty ifTrue: [copy at: 1 put: self first asUppercase].
	^copy
%
category: 'SmallInterfaces'
method: CharacterCollection
evaluate
%
category: 'SmallInterfaces'
method: CharacterCollection
firstLine

	^(self asSequenceableCollection: Character lf) first
%
category: 'SmallInterfaces'
method: CharacterCollection
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: ExecutableBlock
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: ExecutableBlock
whileTrue
	"Evaluate the receiver once and then repeatedly as long as the value
	returned by the evaluation is true."

	^[self value] whileTrue: []
%
category: 'SmallInterfaces'
method: GsMethod
selectorWithArgumentsString

	| firstLine |
	self sourceString isEmpty ifTrue: [^self selector asSelectorStringWithArguments].
	
		"make the crudest attempt: assume the method header is all in the first line
		(like any good formatting practice would dictate...)"
	firstLine := self sourceString firstLine.
	^(firstLine subStrings includesAll: self selector keywordsForSmallInterfaces)
		ifTrue: [firstLine]
		ifFalse: [self selector asSelectorStringWithArguments]
%
category: 'SmallInterfaces'
method: GsMethod
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Dictionary
intersectionWithSet: aSet
	"Return the elements in common with receiver and aSet 
	as a set with one instance of each value in receiver that is equal to one in aSet"

	^self values asSet intersectionWithSet: aSet
%
category: 'SmallInterfaces'
method: Dictionary
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Set
& aSet 
	"Set intersection"

	^self intersectionWith: aSet
%
category: 'SmallInterfaces'
method: Set
+ aCollection 
	"Set union"

	^self , aCollection
%
category: 'SmallInterfaces'
method: Set
, aCollection 
	"Answer a copy of the receiver concatenated with the argument, aCollection."
	
	^self copy
		addAll: aCollection asSet;
		yourself
%
category: 'SmallInterfaces'
method: Set
- aSet
	"Answer those elements present in the receiver and absent from aSet."

	^self reject: [ :i | aSet includes: i ]
%
category: 'SmallInterfaces'
method: Set
intersectionWith: aSet
	"Intersection of two sets."

	^self select: [:each | aSet includes: each]
%
category: 'SmallInterfaces'
method: Set
intersectionWithSet: aSet
	"Return the elements in common with receiver and aSet as a set with one instance of each element.
	<#(1 2 3) asSet intersectionWithSet: #(2 3 4) asSet>"

	^(self size <= aSet size)
		ifTrue: [self select: [:each | aSet includes: each]]
		ifFalse: [aSet intersectionWithSet: self]
%
category: 'SmallInterfaces'
method: Set
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: Symbol
asClass
	"Answer the class I designate. Return nil if no such class exists.
	<#String asClass>
	<'Array' asClass>
	<'foo' asClass>"

	^self environment 
		at: self  
		ifAbsent: [nil]
%
category: 'SmallInterfaces'
method: Symbol
asSelectorStringWithArguments
	"<#at:put: asSelectorStringWithArguments>
	<#_at:put: asSelectorStringWithArguments>
	<#halt asSelectorStringWithArguments>
	<#@ asSelectorStringWithArguments>"
	
	^(self occurrencesOf: $:) > 0
		ifTrue:
			[| writer |
			writer := WriteStream on: String newLarge.
			self keywordsForSmallInterfaces withIndexDo: 
				[:index :each |
				writer 
					nextPutAll: each;
					nextPutAll: ' arg';
					nextPutAll: index printString;
					space].
			writer contents]
		ifFalse:
			[self isUnary 
				ifTrue: [self asString]
				ifFalse:
					[self isBinary 
						ifTrue: [self asString, ' anObject']
						ifFalse: [self error: '']]]						
	
	"Note: due to a bug in #isKeyword (affecting #numArgs and #keywords).
	we have to use #keywordsForSmallInterfaces and a non-natural flow of control."
%
category: 'SmallInterfaces'
method: Symbol
isBinary
	"if I am to be interpreted as a message selector, am I a binary method? (such as #<).
	<#@ isBinary>
	<#== isBinary>
	<#halt isBinary>
	<#at: isBinary>"

	^self numArgs = 1 and: [(self endsWith: $:) not]
%
category: 'SmallInterfaces'
method: Symbol
isUnary
	"if I am to be interpreted as a message selector, am I an unary method? (such as #class).
	<#@ isUnary>
	<#halt isUnary>
	<#at: isUnary>"

	^self numArgs = 0
%
category: 'SmallInterfaces'
method: Symbol
keywordsForSmallInterfaces
	"Answer an array of the keywords that compose the receiver.
	<#_at:_put: keywordsForSmallInterfaces>"

	| result aStream len |
	result := WriteStream on: (Array new: 10).
	aStream := WriteStream on: (String new: 16).
	len := self size.
	1 to: len do:
		[:i | | char |
		char := self at: i.
		aStream nextPut: char.
		(char = $: or: [i = len])
			ifTrue: 
				[result nextPut: aStream contents.
				aStream reset]].
	^result contents
%
category: 'SmallInterfaces'
method: Symbol
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
method: SymbolDictionary
classes
	"<Globals classes>"

	^ClassSet withAll: (self values select: [:each | each isClass])
%
category: 'SmallInterfaces'
method: SymbolDictionary
versionOfSmallInterfaces

	^'1.4.2'
%
category: 'SmallInterfaces'
classmethod: Collection
newLarge

	^self new: 100
%
category: 'SmallInterfaces'
classmethod: Stream
newLarge

	^self on: self contentsSpecies newLarge
%
category: 'SmallInterfaces'
classmethod: ClassOrganizer
defaultProtocol

	^#'As yet unclassified'
%
category: 'SmallInterfaces'
classmethod: ClassOrganizer
versionOfSmallInterfaces

	^'1.4.2'
%
